--this file contains the create moving bat function

function create_moving_bat(path, is_circular,layer) --the list of path, is the movement circular,the layer
    --PATH
    local path_list = path
    local crea_speed = 300.0
    local start_script = "data/scripts/point10.lua"
    local end_script = ""
    local trigger_radius = 30.0
    local scale = 1.0

    --CREATURE start
    lua:create_creature("moving_bat", CPT_MOVING_CREATURE, "flying_bat", "", "", "") -- name, type, stand_animation, run_animation, jump_up_animation, jump_down_animation
    lua:creature_speed("moving_bat", CPT_MOVING_CREATURE, crea_speed) -- name, type, speed
    lua:creature_shape("moving_bat",CPT_MOVING_CREATURE,64.0*scale,64.0*scale) --name, type, half_width,half_height
    lua:creature_color("moving_bat", CPT_MOVING_CREATURE, 1.0, 1.0, 1.0, 1.0) --name, type , rgba
    lua:creature_translation("moving_bat", CPT_MOVING_CREATURE, path_list[1][1], path_list[1][2]) -- set the creature to it's right position

    lua:create_circle("creature_shape",0.0, 0.0, trigger_radius) --name, x,y, radius
    lua:create_trigger("creature_gate", TT_GATE, start_script,end_script,0.0,0.0) --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape("creature_gate", TT_GATE, "creature_shape") --name, type, shape_name
    lua:trigger_add_group_i_belong_to("creature_gate", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me("creature_gate", TT_GATE, "player") --name, type, group_name
    lua:creature_trigger("moving_bat",CPT_MOVING_CREATURE,"creature_gate",g_level.next_id()) -- name, type, trigger_name

    lua:create_pathing_graph(is_circular)         -- is_circular
    for i=1,#path_list,1 do
        local tmp_list = path_list[i]
        lua:add_pathing_graph_point(tmp_list[1],tmp_list[2])
    end
    lua:create_ai("moving_bat","patrol")  -- creature, state name

    g_level.upload("moving_bat",layer) 
end

--this file contains the create still bat function

function create_still_bat(x,y, is_circular,layer) --x,y, is the movement circular,the layer
    --PATH
    local crea_speed = 0.0
    local start_script = "data/scripts/point10.lua"
    local end_script = ""
    local trigger_radius = 30.0
    local scale = 1.0

    --CREATURE start
    lua:create_creature("still_bat", CPT_MOVING_CREATURE, "still_bat", "", "", "") -- name, type, stand_animation, run_animation, jump_up_animation, jump_down_animation
    lua:creature_speed("still_bat", CPT_MOVING_CREATURE, crea_speed) -- name, type, speed
    lua:creature_shape("still_bat",CPT_MOVING_CREATURE,64.0*scale,64.0*scale) --name, type, half_width,half_height
    lua:creature_color("still_bat", CPT_MOVING_CREATURE, 1.0, 1.0, 1.0, 1.0) --name, type , rgba
    lua:creature_translation("still_bat", CPT_MOVING_CREATURE, x, y) -- set the creature to it's right position

    lua:create_circle("creature_shape",0.0, 0.0, trigger_radius) --name, x,y, radius
    lua:create_trigger("creature_gate", TT_GATE, start_script, end_script,0.0,0.0) --name, type, on_enter_script, on_leave_scipt,x,y
    lua:trigger_shape("creature_gate", TT_GATE, "creature_shape") --name, type, shape_name
    lua:trigger_add_group_i_belong_to("creature_gate", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me("creature_gate", TT_GATE, "player") --name, type, group_name
    lua:creature_trigger("still_bat",CPT_MOVING_CREATURE,"creature_gate",g_level.next_id()) -- name, type, trigger_name

    g_level.upload("still_bat",layer) 
end

--LOAD GRAPHICS
lua_init_texture("still_bat", "data/images/sewer/bat_sprite.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_texture("flying_bat", "data/images/sewer/bat_sprite.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
local delay = 0.125
--lua_init_subtexture_animation("flying_bat",4, 4, 1, 5, MODE_PINGPONG, DIRECTION_FORWARD,delay) --name,cols, rows, startf, endf, mode, direction,delay

lua:init_subtexture("flying_bat","flying_bat_1", 0.25, 0.75, 0.0, 1.0)
lua:init_subtexture("flying_bat","flying_bat_2", 0.5, 0.75, 0.25, 1.0)
lua:init_subtexture("flying_bat","flying_bat_3", 0.75, 0.75, 0.5, 1.0)
lua:init_subtexture("flying_bat","flying_bat_4", 1.0, 0.75, 0.75, 1.0)
lua:init_subtexture("flying_bat","flying_bat_5", 0.25, 0.5, 0.0, 0.75)
lua:init_animation("flying_bat",MODE_PINGPONG,DIRECTION_FORWARD)
lua:animation_add_frame("flying_bat","flying_bat_1",delay)
lua:animation_add_frame("flying_bat","flying_bat_2",delay)
lua:animation_add_frame("flying_bat","flying_bat_3",delay)
lua:animation_add_frame("flying_bat","flying_bat_4",delay)
lua:animation_add_frame("flying_bat","flying_bat_5",delay)

local delay = 1.5
lua_init_subtextures("still_bat",4,4,1,16)
lua:init_animation("still_bat",MODE_PINGPONG,DIRECTION_FORWARD)
lua:animation_add_frame("still_bat","still_bat_11",delay)
lua:animation_add_frame("still_bat","still_bat_12",delay)
lua:animation_add_frame("still_bat","still_bat_13",delay)
lua:animation_add_frame("still_bat","still_bat_14",delay)